
-- IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_DANFE_PROVISORIO_EXCLUSAO]') AND type in (N'P', N'PC'))
-- DROP PROCEDURE [dbo].[P_EST_PROD_DANFE_PROVISORIO_EXCLUSAO]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO]
GO
GO
/****** Object:  StoredProcedure [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO]    Script Date: 10/21/2013 17:49:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO]
GO
GO
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: 
'Tabelas.............: 
'Dt Modificação......: 11/03/2021
'Modificação.........: Tag #A001 Ajuste para passar um parâmetro para reimportação automática opcional 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
--EXEC P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO 424041
*/

CREATE PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO] (@CD_CTR_DANFE INT, @IMPORTA INT = 0)
with encryption as
SET NOCOUNT ON;
DECLARE @CD_FILIAL INT
DECLARE @CD_FORN INT
DECLARE @NR_NF INT
DECLARE @DT_EMI_NF DATETIME
DECLARE @CD_CTR_FORN_VALID INT

DECLARE @BANCO_NFE VARCHAR(100)
DECLARE @CHAVE_NFE VARCHAR(100)
DECLARE @ID BIGINT
DECLARE @SQL NVARCHAR(4000)

if exists(select cd_emp from 
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT
			where cd_Ctr=@CD_CTR_DANFE)
begin
	DELETE FROM EST_NF_ENT_DANFE_PROVISORIO_PENDENTE WHERE CD_CTR=@CD_CTR_DANFE
	print 'Danfe com entrada realizada.'
	return
end

--Buscando dados para tratar a fornecedor Valid
select
	@CD_FILIAL=CD_FILIAL, 
	@CD_FORN=CD_FORN, 
	@NR_NF=NR_NF,
	@DT_EMI_NF=DT_EMIS_NF
from
	EST_NF_ENT_DANFE_PROVISORIO
where
	CD_CTR = @CD_CTR_DANFE

--Codigo de controle da fornecedor valid
SELECT
	@CD_CTR_FORN_VALID=CD_CTR
FROM
	EST_NF_ENT_NFE_FORN_VALID
WHERE
	CD_EMP=1
	AND CD_FILIAL = @CD_FILIAL
	AND CD_FORN=@CD_FORN
	AND NR_NF = @NR_NF
	AND DT_EMI_NF=@DT_EMI_NF

--Iniciando exclusao fornecedor valid
delete from 
	EST_NF_ENT_NFE_FORN_VALID_PENDENTE
WHERE
	CD_CTR = @CD_CTR_FORN_VALID
	
	
delete FROM
	EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID
WHERE
	CD_CTR = @CD_CTR_FORN_VALID

delete from
	EST_NF_ENT_NFE_FORN_VALID
WHERE
	CD_CTR=@CD_CTR_FORN_VALID
--Fim Fornecedor valid


--Iniciando exclusao danfe provisorio
delete from
	EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO
where
	CD_CTR = @CD_CTR_DANFE
	
delete from
	EST_NF_ENT_DANFE_PROVISORIO_SUSPENSO
where
	CD_CTR = @CD_CTR_DANFE

	
delete from
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA
where
	CD_CTR = @CD_CTR_DANFE
	
DELETE
	ADM_ERRO
FROM
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO INNER JOIN ADM_ERRO ON
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO.CODIGO = ADM_ERRO.CODIGO
WHERE
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = @CD_CTR_DANFE

DELETE
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO 
WHERE
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_ITENS_LOTE
where
	CD_CTR_DANFE = @CD_CTR_DANFE

delete from 
	EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PENDENTE
WHERE
	CD_CTR = @CD_CTR_DANFE
	
delete from
	EST_NF_ENT_DANFE_PROVISORIO_ITENS
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_PENDENTE
where
	CD_CTR = @CD_CTR_DANFE

delete from 
	EST_NF_ENT_DANFE_PROVISORIO_SEM_PEDIDO
WHERE
	CD_CTR = @CD_CTR_DANFE	


DELETE 
	FROM 
		EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO
WHERE
	CD_CTR = @CD_CTR_DANFE	

delete from
	EST_NF_ENT_DANFE_PROVISORIO_FILIAIS
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO
where
	CD_CTR = @CD_CTR_DANFE
	
delete from
	EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA
where
	CD_CTR = @CD_CTR_DANFE

delete from
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO
where
	CD_CTR = @CD_CTR_DANFE

delete from
	EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO_PENDENTE
where
	CD_CTR = @CD_CTR_DANFE
	 
	
delete from
	EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_OPERACAO
where
	CD_CTR = @CD_CTR_DANFE


delete from
	EST_NF_ENT_DANFE_PROVISORIO_TRANSP
where
	CD_CTR = @CD_CTR_DANFE


IF @IMPORTA = 1
BEGIN
	SELECT
		@CHAVE_NFE = NR_AUTORIZADOR
	FROM
		EST_NF_ENT_DANFE_PROVISORIO
	WHERE
		CD_CTR = @CD_CTR_DANFE

	delete from
		EST_NF_ENT_DANFE_PROVISORIO
	where
		CD_CTR = @CD_CTR_DANFE

	--PEGANDO O NOME DO BANCO DE DADOS NFE
	SELECT TOP 1
		@BANCO_NFE = NOME_BANCO_DADOS
	FROM
		PRC_BANCOS_DADOS
	WHERE
		TIPO_BANCO_DADOS = 2

	SET @SQL = 'SELECT TOP 1 @ID = ID FROM ' + @BANCO_NFE + '..EST_NF_NFE_RECEBIMENTO WHERE CHAVE_NFE = ''' + @CHAVE_NFE + ''''
	EXEC SP_EXECUTESQL @Query = @SQL, @Params = N'@ID BIGINT OUTPUT', @ID = @ID OUTPUT

	--REPROCESSANDO O XML PARA REIMPORTACAO
	SET @SQL = 'UPDATE ' + @BANCO_NFE + '..EST_NF_NFE_RECEBIMENTO SET STS_IMPORT = 6 WHERE ID = ' + CONVERT(VARCHAR(100), @ID)
	EXEC SP_EXECUTESQL @SQL
END

--Fim
